﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;


namespace SM_Series_SDK
{
    public class SPdbUSBm
    {
        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spTestAllChannels(short sOrderType);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetupAllChannels();

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetupGivenChannel(short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spInitAllChannels(short sCCDType);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spInitGivenChannel(short sCCDType, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetIntEx(Int32 lIntTime, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetDblIntEx(double lIntTime, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetTrgEx(short sTrgType, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spReadDataEx(Int32[] lpArray, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spCloseAllChannels();

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spCloseGivenChannel(short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spWriteChannelID(short sNum, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spReadChannelID(short spNum, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern void spGetAssignedChannelID(short spChannelID);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern void spPolyCalc(double[] coefs, short order, double x, double[] y);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spPolyFit(double[] x, double[] y, short numPts, double[] coefs, short order);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetIntMode(short IntMode, double dIntTime, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetExtEdgeMode(short EdgeMode, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spCheckSpeedMode(int nCheckSpeed, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spGetDevIsNew(short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spDevInfo(StringBuilder strModel, StringBuilder strSerial, short sChannel);

        [DllImport("SPdbUSBm", SetLastError = true)]
        public static extern short spGetCCDType(short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spGetWLTable(double[] WLTable, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spDupdate(int ScanAvg, int smooth, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetUSBTx(short sTxSpeed, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spReadDataExOutTrg(Int32[] lpArray, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetOutTrgPin(short sOutPin, short sChannel);


        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spReadDark(Int32[] DarkArray, int Avg, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetOffsetCorrection(bool bApply, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetBaseLineCorrection(bool bApply, short sOffset, double dGain, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSelectCF(long lCF, short sChannel);

        [DllImport("SPdbUSBm.dll", SetLastError = true)]
        public static extern short spSetTEC(long lTEC, short sChannel);
    }

    public enum OrderType
    {
        SP_ORDER_BY_USBPORTNUM = 0,
        SP_ORDER_BY_CHANNELID = 1
    };
    public enum CCDType
    {
        SP_CCD_SONY = 0,
        SP_CCD_TOSHIBA = 1,
        SP_CCD_PDA = 2,
        SP_CCD_G9212 = 3,       // InGaAs
        SP_CCD_S10420 = 4,      //Non Cooled BT Back thinned CCD
        SP_CCD_G92XX_256 = 5,
        SP_CCD_S10141 = 6,      //SM303 S10141 CCD
        SP_CCD_TCD1304AP = 7    //SM445
    };
    public enum TriggerMode{
        SP_TRIGGER_OFF = 10,
        SP_TRIGGER_INTERNAL = 11,
        SP_TRIGGER_EXTERNAL = 12
    };
    public enum InternalTriggerMode{
        SP_INTMODE_SWTRIGGER = 0,
        SP_INTMODE_FREERUN_PREV = 1,
        SP_INTMODE_FREERUN_NEXT = 2
    };
    public enum ExternalTriggerEdgeMode{
        SP_EXTEDGE_FALLING = 0,
        SP_EXTEDGE_RISING = 1
    }
    public enum PixelInfo{
        SP_CCD_PIXEL_G9212 = 512,   // InGaAs
        SP_CCD_PIXEL_G9212_REAL = 512,
        SP_CCD_PIXEL_PDA = 1056,    // Back thinned CCD, it has to be a multiple of "32"
        SP_CCD_PIXEL_PDA_REAL = 1024,
        SP_CCD_PIXEL_SONY = 2080,
        SP_CCD_PIXEL_SONY_REAL = 2048,
        SP_CCD_PIXEL_TOSHIBA = 3680,
        SP_CCD_PIXEL_TOSHIBA_REAL = 3648,
        SP_CCD_PIXEL_S10420 = 2080, // Non Cooled Back thined
        SP_CCD_PIXEL_S10420_REAL = 2048,
        SP_CCD_PIXEL_S10141 = 2080,
        SP_CCD_PIXEL_S10141_REAL = 2048,
        SP_CCD_PIXEL_TCD1304AP = 3680,
        SP_CCD_PIXEL_TCD1304AP_REAL = 3648
    };
}
